#!/usr/bin/env python
import pyfirmata
from Tkinter import *

arduinoboard = pyfirmata.Arduino('/dev/ttyACM0')

pin3 = arduinoboard.get_pin('d:3:p') # Broche 3 en MLI

def cleanup():
    # LED 3 éteinte
    pin3.write(0)
    arduinoboard.exit()
    
def setPWM(pwm):
    # LED 3 pilotée en MLI
    # Les valeurs comprises entre 0 et 1 sont acceptées
    pin3.write(float(pwm)/100.0)    

# GUI Interface graphique
master = Tk()
master.wm_protocol("WM_DELETE_WINDOW", cleanup)

# Initialisation du potentiomètre linéaire
scale = Scale(master,
    from_ = 0,
    to = 100,
    command = setPWM,
    orient = HORIZONTAL,
    length = 400,
    label = 'PWM-Value')

scale.pack(anchor = CENTER) # Placer au milieu
master.mainloop()           # Démarrage de la boucle d'interrogation TK
